package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="facility", schema="dart")
public abstract class Facility {

	@Id
	@Column(name="facilityid")
	protected int id;
	
	@Column(name="facilityname")
	protected String name;
	
	@Column(name="visn")
	private int visn;
	
	@Column(name="region")
	private int region;  

	@Column(name="sta3n")
	private int sta3n;

	protected Facility() {}
	
	public static Facility findById(final int locationId) {
		return DartObjectFactory.getInstance().getFacilityDAO().findById(locationId);
	}
	
	public static List<Facility> listAll() {
		return DartObjectFactory.getInstance().getFacilityDAO().listAll();
	}
	
	public static Facility findByName(final String name) throws ObjectNotFoundException, ValidationException {
		ValidationHelper.required("Facility Name", name);
		ValidationHelper.validateSize("Facility Name", name, 1, 64);
		
		return DartObjectFactory.getInstance().getFacilityDAO().findByName(name);
	}
	
	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public int getVisn() {
		return visn;
	}

	public int getRegion() {
		return region;
	}

	public int getSta3n() {
		return sta3n;
	}
}
